#include <cassert>
#include <cstdio>
#include <ctime>
#include <cstdlib>
#include <cstring>
#include <cmath>
#include <algorithm>
#include <iostream>
#include <set>
#include <map>
#include <vector>
#include <queue>
#include <deque>
using namespace std;
#define pb push_back
#define mp make_pair
#define fs first
#define sc second
#define sz(a) ((int) (a).size())
#define eprintf(...) fprintf(stderr, __VA_ARGS__)
#define int64 long long
#define ldb long double
const double pi = acos(-1.0);
const double eps = 1e-10;
int n, C;

bool cmp(const pair<double, double>& a, const pair<double, double>& b) {
	return a.fs / a.sc < b.fs / b.sc;
}

double compute(const vector< pair<double, double> >& v, double x, double C) {
	double res = 0;
	for (int i = 0; i < sz(v); ++i)
		res += max(0.0, v[i].fs - x * v[i].sc);
	return res + x * C;
}

int main() {
	assert(freopen("input.txt", "r", stdin));
	assert(freopen("output.txt", "w", stdout));
	while ((scanf("%d", &n) == 1) && (n > 0)) {
		scanf("%d", &C);
		double res = 1e18, vw, pf, vf, th, sum = 0, cur = 0, old = 0, delta = 0;
		vector< pair<double, double> > v;
		for (int i = 0; i < n; ++i) {
			scanf("%lf%lf%lf%lf", &vw, &pf, &vf, &th);
			if (fabs(vw) < eps)
				delta += max(0.0, th * pf / vf);
			else
				v.pb(mp(th * pf / vf, vw * pf / vf));
		}
		if (v.empty())
			res = 0;
		else {
			sort(v.begin(), v.end(), cmp);
			for (int i = 0; i < sz(v); ++i)
				if (v[i].sc > 0) sum -= v[i].sc;
			res = compute(v, 0, C), old = (v[0].fs / v[0].sc), cur = compute(v, old, C);
			for (int i = 0; i < sz(v); ++i) {
				double nval = (v[i].fs / v[i].sc);
				cur += C * (nval - old) + sum * (nval - old);
				if (nval > -eps) res = min(res, cur);
				old = nval, sum += abs(v[i].sc);
			}
		}
		printf("%.10lf\n", res + delta);
	}
	return 0;
}